/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 /page/gamma页面函数(硬件)
*
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.05.11
*      内容 : 所有代码
************************************************************************************************/

/* exported tc_init_hw_gamma */
/* exported tc_record_hw_gamma */
/* exported tc_tab_bar */
/* exported tc_load_the_configuration */
/* exported tc_save_the_configuration */
/* exported tc_send_solidify */
/* exported tc_readback */

/* global $ */
/* global mc_sdk_param */

// 页面层级
// 顶层
var obj_gamma_iframe_top = "";
// main层
var obj_gamma_iframe_sub_main = "";
// 子页面层
var obj_gamma_iframe_child_page = "";
// 子页面dom层
var obj_gamma_html_child_page = "";
// 子页面方面变量定义层
var obj_gamma_window_child_page = "";

// 比较数据结果
var arr_jungle_result = [];

// 初始化数据
var obj_init_data = {
    "gray": "12",
    "max_y": "65535",
    "gamma_val": "2.8",
    "mod": "1",
    "tbl_val": []
};

// 用于比较界面数据 (应出现的数据)
var obj_jungle_data = JSON.parse(JSON.stringify(obj_init_data));
var obj_page_data = JSON.parse(JSON.stringify(obj_init_data));

// 用于比较表格数据 ( 主要是加载/保存配置 , 发送/固化/回读 )
var arr_jungle_data = [];
var arr_page_data = [];

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试初始化界面数据是否正确
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function tc_init_hw_gamma(callback) {
    // 恢复默认值
    // obj_jungle_data = JSON.parse(JSON.stringify(obj_init_data));
    // 清空界面
    mc_gamma_clear_iframe_page();
    // 获取硬件数据tbl_val
    mc_gamma_get_gamma(function (init_data) {
        obj_jungle_data.tbl_val = init_data;
        // 打开界面
        mc_gamma_jungle_open_subpage(function () {
            // 获取界面数据
            mc_get_page_data();

            // 比较数据
            arr_jungle_result = mc_jungle_data(obj_page_data, obj_jungle_data);

            if (arr_jungle_result[0]) {
                callback("1", "数据正确");
            } else {
                callback("0", arr_jungle_result[1]);
            }
            return;
        });
    }, obj_jungle_data.mod, obj_jungle_data.gray, obj_jungle_data.max_y, obj_jungle_data.gamma_val);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试界面记录功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function tc_record_hw_gamma(callback) {
    // 清空界面
    mc_gamma_clear_iframe_page();
    // 打开界面
    mc_gamma_jungle_open_subpage(function () {
    // obj_gamma_iframe_top;
    // obj_gamma_iframe_sub_main;
    // obj_gamma_iframe_child_page;
    // 获取id 模拟修改控件
        var id_gray = obj_gamma_window_child_page.gam_select_event.get_id();
        var id_max_y = obj_gamma_window_child_page.gam_y_edit_right.get_id();
        var id_gamma_val = obj_gamma_window_child_page.gam_slider.get_id();
        var id_mod = obj_gamma_window_child_page.gam_checked.get_id();

        // 修改参数发送数据
        obj_gamma_window_child_page.gam_select_event.set_dom_val("10");
        obj_gamma_window_child_page.onValchg(id_gray, "10", "", "");
        setTimeout(() => {
            obj_gamma_window_child_page.gam_slider.set_dom_val("3.5");
            obj_gamma_window_child_page.onValchg(id_gamma_val, "3.5", "", "");
            setTimeout(() => {
                obj_gamma_window_child_page.gam_checked.set_dom_val("MC_LANG_BTN_GAM_STANDARD");
                obj_gamma_window_child_page.onValchg(id_mod, "MC_LANG_BTN_GAM_STANDARD", "", "");
                setTimeout(() => {
                    obj_gamma_window_child_page.gam_y_edit_right.set_dom_val("40000");
                    obj_gamma_window_child_page.onValchg(id_max_y, "40000", "", "");
                    setTimeout(() => {
                        // 获取界面数据
                        mc_get_page_data();
                        // 由页面数据转给比较数据 防止已修改参数 不使用默认值
                        obj_jungle_data = JSON.parse(JSON.stringify(obj_page_data));

                        // 关闭界面 后打开界面
                        mc_remove_dialog_subpage("subpage");

                        mc_gamma_jungle_open_subpage(function () {
                            // 获取界面数据
                            mc_get_page_data();
                            // 比较数据
                            arr_jungle_result = mc_jungle_data(obj_page_data, obj_jungle_data);

                            if (arr_jungle_result[0]) {
                                callback("1", "数据正确");
                            } else {
                                callback("0", arr_jungle_result[1]);
                            }
                            return;
                        });
                    }, 500);
                }, 500);
            }, 500);
        }, 500);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试tab栏界面效果及记忆功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function tc_tab_bar(callback) {
    // 清空界面
    mc_gamma_clear_iframe_page();
    // 打开界面
    mc_gamma_jungle_open_subpage(function () {
    // obj_gamma_iframe_top;
    // obj_gamma_iframe_sub_main;
    // obj_gamma_iframe_child_page;

        // 切换tab栏
        var id_tab = obj_gamma_window_child_page.gam_tab_btn.get_id();

        obj_gamma_window_child_page.gam_tab_btn.set_dom_default(1);
        obj_gamma_window_child_page.onValchg(id_tab, "自定义表", "", "");

        // 检测界面是否存在控件
        var arr_html_contral = ["mc_gray_scale", "mc_x_axis_area", "mc_y_axis_area", "mc_straight_scroll", "mc_radio_checkbox"];

        for (var idx = 0; 5 > idx; idx++) {
            if ("none" !== obj_gamma_html_child_page.getElementsByClassName(arr_html_contral[idx])[0].style.display) {
                callback("0", "出现界面控件,显示有误");
                return;
            }
        }

        setTimeout(() => {
            // 清空界面
            mc_remove_dialog_subpage("subpage");

            mc_gamma_jungle_open_subpage(function () {
                // 检验是否有控件

                for (var id = 0; 5 > id; id++) {
                    if ("none" !== obj_gamma_html_child_page.getElementsByClassName(arr_html_contral[id])[0].style.display) {
                        callback("0", "出现界面控件,显示有误");
                        return;
                    }
                }

                // 检验当前是否选中自定义表
                if ("1" !== obj_gamma_html_child_page.getElementsByClassName("mc_tab")[0].getAttribute("default_idx")) {
                    callback("0", "tab栏显示正确");
                    return;
                }

                callback("1", "显示正确");
                return;
            });
        }, 500);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试加载配置文件
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    由于加载事件 打开文件选择器仅由用户激活时才显示 故不模拟点击事件 直接给予已知数据 走加载成功后的绘图逻辑 判断是否一致
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_load_the_configuration(callback) {
    // 清空界面
    mc_gamma_clear_iframe_page();
    // 打开界面
    mc_gamma_jungle_open_subpage(function () {
    // 加载的文件数据
        arr_jungle_data = ["0", "0", "0", "0", "0", "0", "1", "1", "1", "2", "2", "3", "4", "5", "7", "8", "10", "12", "14", "17", "19", "22", "26", "29", "33", "38", "42", "47", "53", "59", "65", "72", "79", "87", "95", "103", "113", "122", "132", "143", "154", "166", "179", "192", "205", "220", "235", "250", "267", "284", "302", "320", "339", "359", "380", "401", "424", "447", "471", "495", "521", "548", "575", "603", "632", "662", "694", "726", "759", "792", "827", "863", "900", "938", "978", "1018", "1059", "1101", "1145", "1189", "1235", "1282", "1330", "1379", "1430", "1481", "1534", "1589", "1644", "1701", "1759", "1818", "1878", "1940", "2004", "2068", "2134", "2202", "2270", "2341", "2412", "2485", "2560", "2636", "2714", "2793", "2873", "2955", "3039", "3124", "3211", "3299", "3389", "3481", "3574", "3669", "3765", "3864", "3964", "4065", "4169", "4274", "4380", "4489", "4599", "4712", "4826", "4941", "5059", "5179", "5300", "5423", "5548", "5675", "5804", "5935", "6068", "6203", "6340", "6479", "6619", "6762", "6907", "7054", "7203", "7354", "7508", "7663", "7820", "7980", "8142", "8306", "8472", "8640", "8811", "8983", "9158", "9336", "9515", "9697", "9881", "10067", "10256", "10447", "10641", "10837", "11035", "11235", "11438", "11644", "11852", "12062", "12275", "12490", "12708", "12929", "13152", "13377", "13605", "13836", "14069", "14305", "14543", "14784", "15028", "15274", "15523", "15775", "16029", "16286", "16546", "16809", "17074", "17342", "17613", "17887", "18164", "18443", "18726", "19011", "19299", "19590", "19884", "20180", "20480", "20783", "21088", "21397", "21708", "22023", "22341", "22661", "22985", "23312", "23642", "23975", "24311", "24650", "24992", "25338", "25687", "26039", "26394", "26752", "27113", "27478", "27846", "28217", "28592", "28970", "29351", "29736", "30123", "30515", "30909", "31307", "31708", "32113", "32521", "32933", "33348", "33767", "34189", "34615", "35044", "35476", "35912", "36352", "36795", "37242", "37693", "38147", "38605", "39066", "39531", "40000"];

        // 绘制加载文件的数据
        obj_gamma_window_child_page.arr_gamma_data = arr_jungle_data;
        obj_gamma_window_child_page.mc_gamma_tbl_paint();
        // 获取数据
        mc_get_page_data();
        arr_page_data = obj_page_data.tbl_val;
        // 比较数据
        arr_jungle_result = mc_jungle_data(arr_page_data, arr_jungle_data);

        if (arr_jungle_result[0]) {
            callback("1", "数据正确");
        } else {
            callback("0", arr_jungle_result[1]);
        }
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试保存配置文件
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_save_the_configuration(callback) {
    // 清空界面
    mc_gamma_clear_iframe_page();
    // 打开界面
    mc_gamma_jungle_open_subpage(function () {
    // 修改界面参数
        var id_tbl = obj_gamma_window_child_page.gam_table.get_id();
        // 修改5次

        obj_gamma_html_child_page.getElementsByClassName("table_row")[9].children[1].innerText = "5000";
        obj_gamma_html_child_page.getElementsByClassName("table_row")[9].children[1].setAttribute("lang_id", "5000");
        obj_gamma_window_child_page.onValchg(id_tbl, "5000", 1, 9);

        obj_gamma_html_child_page.getElementsByClassName("table_row")[29].children[1].innerText = "10000";
        obj_gamma_html_child_page.getElementsByClassName("table_row")[29].children[1].setAttribute("lang_id", "10000");
        obj_gamma_window_child_page.onValchg(id_tbl, "10000", 1, 29);

        obj_gamma_html_child_page.getElementsByClassName("table_row")[59].children[1].innerText = "15000";
        obj_gamma_html_child_page.getElementsByClassName("table_row")[59].children[1].setAttribute("lang_id", "15000");
        obj_gamma_window_child_page.onValchg(id_tbl, "15000", 1, 59);

        obj_gamma_html_child_page.getElementsByClassName("table_row")[89].children[1].innerText = "10000";
        obj_gamma_html_child_page.getElementsByClassName("table_row")[89].children[1].setAttribute("lang_id", "10000");
        obj_gamma_window_child_page.onValchg(id_tbl, "10000", 1, 89);

        obj_gamma_html_child_page.getElementsByClassName("table_row")[119].children[1].innerText = "5000";
        obj_gamma_html_child_page.getElementsByClassName("table_row")[119].children[1].setAttribute("lang_id", "5000");
        obj_gamma_window_child_page.onValchg(id_tbl, "5000", 1, 119);

        // 点击保存按钮 获取保存界面的数据
        obj_gamma_html_child_page.getElementsByClassName("icon-boxconfig-save")[0].onclick();
        arr_jungle_data = mc_gamma_get_data_json();

        // 获取数据
        mc_get_page_data();
        arr_page_data = obj_page_data.tbl_val;

        // 比较数据
        arr_jungle_result = mc_jungle_data(arr_page_data, arr_jungle_data);

        if (arr_jungle_result[0]) {
            callback("1", "数据正确");
        } else {
            callback("0", arr_jungle_result[1]);
        }
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试发送/固化gamma
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_send_solidify(callback) {
    // 清空界面
    mc_gamma_clear_iframe_page();
    mc_gamma_jungle_open_subpage(function () {
        mc_get_page_data();
        arr_page_data = obj_page_data.tbl_val;

        // 点击发送、固化
        obj_gamma_html_child_page.getElementsByClassName("icon-hardware-write")[0].onclick();
        setTimeout(() => {
            // 点击发送
            obj_gamma_iframe_child_page[1].getElementsByTagName("iframe")[0].contentDocument.getElementsByClassName("icon-hardware-write")[0].onclick();

            arr_jungle_data = mc_gamma_get_data_json();

            // 比较数据
            arr_jungle_result = mc_jungle_data(arr_page_data, arr_jungle_data);

            if (arr_jungle_result[0]) {
                // callback("1", "数据正确");
            } else {
                callback("0", arr_jungle_result[1]);
                return;
            }
            // 发送有异步
            setTimeout(() => {
                // 去掉提示框
                mc_remove_dialog_subpage("dialog");
                obj_gamma_iframe_child_page[1].remove();
                obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[1].remove();


                var id_send_gray = obj_gamma_window_child_page.gam_select_event.get_id();

                obj_gamma_window_child_page.gam_select_event.set_dom_val("9");
                obj_gamma_window_child_page.onValchg(id_send_gray, "9", "", "");
                setTimeout(() => {
                    // 获取界面数据
                    mc_get_page_data();
                    arr_page_data = obj_page_data.tbl_val;
                    // 点击发送/固化
                    obj_gamma_html_child_page.getElementsByClassName("icon-hardware-write")[0].onclick();
                    setTimeout(() => {
                        obj_gamma_iframe_child_page[1].getElementsByTagName("iframe")[0].contentDocument.getElementsByClassName("icon-hardware-save")[0].onclick();
                        arr_jungle_data = mc_gamma_get_data_json();
                        // 比较数据
                        arr_jungle_result = mc_jungle_data(arr_page_data, arr_jungle_data);

                        if (arr_jungle_result[0]) {
                            callback("1", "数据正确");
                        } else {
                            callback("0", arr_jungle_result[1]);
                            return;
                        }
                    }, 500);
                }, 500);
            }, 5000);
        }, 500);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试回读功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function tc_readback(callback) {
    // 清空界面
    mc_gamma_clear_iframe_page();
    mc_gamma_jungle_open_subpage(function () {
    // obj_gamma_iframe_top;
    // obj_gamma_iframe_sub_main;
    // obj_gamma_iframe_child_page;
    // obj_gamma_window_child_page;
    // obj_gamma_html_child_page;
        obj_gamma_html_child_page.getElementsByClassName("icon-hardware-readback")[0].onclick();
        setTimeout(() => {
            obj_gamma_iframe_child_page[1].getElementsByTagName("iframe")[0].contentDocument.getElementsByClassName("icon-hardware-readback")[0].onclick();

            setTimeout(() => {
                mc_remove_dialog_subpage("dialog");
                mc_remove_dialog_subpage("hw_page");

                // 获取界面数据
                mc_get_page_data();
                arr_page_data = obj_page_data.tbl_val;

                arr_jungle_data = mc_gamma_get_data_json();
                if (!arr_jungle_data) {
                    callback("0", "回读数据失败,无法测试是否回读成功");
                    return;
                }
                // 比较数据
                arr_jungle_result = mc_jungle_data(arr_page_data, arr_jungle_data);

                if (arr_jungle_result[0]) {
                    callback("1", "数据正确");
                } else {
                    callback("0", arr_jungle_result[1]);
                    return;
                }
            }, 500);
        }, 500);
    });
}

/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取已存的发送数据
 * 参数:
 *    @param {Promise<Array>}  arr 表格数据

 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.5.12
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_gamma_get_data_json() {
    var arr_return = [];
    var str_json = document.getElementById("tifrem_led").contentDocument.getElementById("iframe_subpage").contentWindow.g_str_test_data;

    if (!str_json || 0 === str_json.length) {
        return false;
    }
    arr_return = str_json.split(",");
    return arr_return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取界面数据
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_page_data() {
    // 获取页面数据
    obj_page_data.gray = obj_gamma_html_child_page.getElementsByClassName("mc_opt_select")[0].getAttribute("mc_select_default");
    obj_page_data.max_y = obj_gamma_html_child_page.getElementsByClassName("mc_y_axis_area_second_value")[0].value;
    obj_page_data.gamma_val = Number(obj_gamma_html_child_page.getElementsByClassName("mc_slider_thumb")[0].innerText).toFixed(1);
    obj_page_data.mod = obj_gamma_html_child_page.getElementsByClassName("mc_radio_item");
    // 模式特殊处理
    for (var idx = 0; 3 > idx; idx++) {
        if ("true" === obj_page_data.mod[idx].getAttribute("radio_select")) {
            obj_page_data.mod = idx + "";
            break;
        }
    }
    var arr_html_tbl = obj_gamma_html_child_page.getElementsByClassName("table_row ");
    var ui_len = arr_html_tbl.length;

    obj_page_data.tbl_val = Array(ui_len);
    for (var id = 0; id < ui_len; id++) {
        obj_page_data.tbl_val[id] = arr_html_tbl[id].children[1].innerText;
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断是否打开第三层子页面 以防同时测试多个时数据不对
 * 参数:
 *    @param { Promise<fun_callback> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function mc_gamma_jungle_open_subpage(callback) {
    obj_gamma_iframe_top = document.getElementById("tifrem_led");
    obj_gamma_iframe_sub_main = obj_gamma_iframe_top.contentDocument.getElementById("iframe_subpage");
    obj_gamma_iframe_child_page = obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-iframe");

    if (0 === obj_gamma_iframe_child_page.length) {
    // 点击进入硬件gamma界面
        $(obj_gamma_iframe_sub_main).contents().find("#mc_side_gamma").click();
        setTimeout(() => {
            obj_gamma_html_child_page = obj_gamma_iframe_child_page[0].getElementsByTagName("iframe")[0].contentDocument;
            obj_gamma_window_child_page = obj_gamma_iframe_child_page[0].getElementsByTagName("iframe")[0].contentWindow;
            callback();
        }, 1500);
        return;
    }
    obj_gamma_html_child_page = obj_gamma_iframe_child_page[0].getElementsByTagName("iframe")[0].contentDocument;
    obj_gamma_window_child_page = obj_gamma_iframe_child_page[0].getElementsByTagName("iframe")[0].contentWindow;
    callback();
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断数据是否正常
 * 参数:
 *    @param { Promise<array/object> } page_data 页面数据
 *    @param { Promise<array/object> } right_data 应该展示的数据
 * 返回:
 *    @return {Promise<Array>} arr_result   比较结果
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-11
 *       内容 : 所有代码
************************************************************************************************/
function mc_jungle_data(page_data, right_data) {
    var arr_result = [true, ""];

    var str_page_type = Object.prototype.toString.call(page_data);
    var str_right_type = Object.prototype.toString.call(right_data);

    if (str_page_type !== str_right_type) {
        arr_result = [false, "数据类型不匹配,无法比较数据"];
        return arr_result;
    }

    // 判断数据类型

    switch (str_page_type) {
    // 数组
    case "[object Array]":
        var ui_page_tbl_len = page_data.length;
        var ui_right_tbl_len = right_data.length;

        if (ui_page_tbl_len !== ui_right_tbl_len) {
            arr_result[0] = false;
            arr_result[1] = "结果数组与预想数组长度不一致";
            return arr_result;
        }

        for (var id = 0; id < ui_page_tbl_len; id++) {
            if (page_data[id] !== right_data[id]) {
                id += 1;
                arr_result = [false, "表格数据不一致,在第" + id + "行"];
                return arr_result;
            }
        }

        break;
    // 对象
    case "[object Object]":
        // 一一对比
        if (page_data.gray !== right_data.gray) {
            arr_result = [false, "灰度数据不一致"];
            return arr_result;
        } else if (page_data.gamma_val !== right_data.gamma_val) {
            arr_result = [false, "GAMMA值数据不一致"];
            return arr_result;
        } else if (page_data.max_y !== right_data.max_y) {
            arr_result = [false, "y区间最大值数据不一致"];
            return arr_result;
        } else if (page_data.mod !== right_data.mod) {
            arr_result = [false, "模式数据不一致"];
            return arr_result;
        }

        // 比较表格数据
        var ui_page_len = page_data.tbl_val.length;
        var ui_right_len = right_data.tbl_val.length;

        if (ui_page_len !== ui_right_len) {
            arr_result = [false, "表格数据长度不一致"];
            return arr_result;
        }

        for (var idx = 0; idx < ui_right_len; idx++) {
            if (page_data.tbl_val[idx] !== right_data.tbl_val[idx]) {
                idx += 1;
                arr_result = [false, "表格数据不一致,在第" + idx + "行"];
                return arr_result;
            }
        }

        break;
    default:
        break;
    }

    return arr_result;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    去掉提示弹窗/子页面弹窗
 * 参数:
 *    @param { Promise<string> } str_type 删除界面类型
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-12
 *       内容 : 所有代码
************************************************************************************************/
function mc_remove_dialog_subpage(str_type) {
    // 弹框提示
    if ("dialog" === str_type) {
        obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        var ui_len_dialog = obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade").length;

        // 去掉最后一个遮罩
        obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[ui_len_dialog - 1].remove();
    }

    // 子页面 第三层
    if ("subpage" === str_type) {
        obj_gamma_iframe_child_page[0].remove();
        obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }

    // 子页面 第二层内 (主要是硬件选择界面)
    if ("hw_page" === str_type) {
        obj_gamma_iframe_child_page[1].remove();
        obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[1].remove();
    }
}

/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */


/* -------------------------------------------------------------------接口函数----------------------------------------------------------------- */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取gamma默认表 拿到初始数据 并处理
 * 参数:
 *    @param {Promise<function>} fun_callback               回调函数
 *    @param {Promise<string>} str_url_gama_mode_value          Gamma模式
 *    @param {Promise<string>} str_url_gray_bit_size      灰度等级
 *    @param {Promise<string>} str_max_val      最大值
 *    @param {Promise<string>} str_url_gamma_factor         灰度计算因子

 * 返回：
 *    @param {Promise<Array>} ary_gamma_tbl         GAMMA数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.05.11
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_gamma_get_gamma(fun_callback, str_url_gama_mode_value, str_url_gray_bit_size, str_max_val, str_url_gamma_factor) {
    var str_default_gamma_json_req = new mc_sdk_param();

    str_default_gamma_json_req.set_param_clear();
    str_default_gamma_json_req.set_cmd("GET_PARAM");
    str_default_gamma_json_req.set_func("GAMA_TABLE");
    str_default_gamma_json_req.set_param_value("GAMA_MODE", str_url_gama_mode_value);
    str_default_gamma_json_req.set_param_value("BRIGHT_PERCENT", "100");
    str_default_gamma_json_req.set_param_value("PIX_INPUT_BIT_SIZE", "8");
    str_default_gamma_json_req.set_param_value("GRAY_BIT_SIZE", str_url_gray_bit_size);
    str_default_gamma_json_req.set_param_value("GAMA_MAX_VAL", str_max_val);
    str_default_gamma_json_req.set_param_value("GAMA_FACTOR", str_url_gamma_factor);

    $.post("/access_shell", str_default_gamma_json_req.get_json(), function (result, status) {
        if ("success" === status) {
            var obj_param_gamma = new mc_sdk_param();

            obj_param_gamma.set_json(result);
            var str_gamma_tbl = obj_param_gamma.get_param_value("GAMA_TABLE");


            //清除空白 改逗号为英文 去掉重复逗号
            var ary_gamma_tbl = str_gamma_tbl.replace(/，/ig, ",").replace(/\s*/g, "").split(",");

            for (var i = 0; i < ary_gamma_tbl.length; i++) {
                if ("" === ary_gamma_tbl[i]) {
                    str_gamma_tbl.splice(i, 1);
                    i--;
                }
            }

            ary_gamma_tbl = str_gamma_tbl.split(",");

            fun_callback(ary_gamma_tbl);
        }
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    清空所有子页面 和弹框
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function mc_gamma_clear_iframe_page() {
    obj_gamma_iframe_top = document.getElementById("tifrem_led");
    obj_gamma_iframe_sub_main = obj_gamma_iframe_top.contentDocument.getElementById("iframe_subpage");
    obj_gamma_iframe_child_page = obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-iframe");

    var ui_iframe_page_cnt = obj_gamma_iframe_child_page.length;

    // 提示弹框
    var arr_dialog_html = obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog");

    if (0 < arr_dialog_html.length) {
        obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
    for (var idx = 0; idx < ui_iframe_page_cnt; idx++) {
        obj_gamma_iframe_child_page[0].remove();
        obj_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
    obj_jungle_data = JSON.parse(JSON.stringify(obj_init_data));
    obj_page_data = JSON.parse(JSON.stringify(obj_init_data));
    var obj_hardware_gamma = {
        "gray_bit": "12",
        "y_val": "65535",
        "factor": "2.80",
        "mode_val_idx": "1",
        "chart_type_name": "Calculate",
        "str_show_data": ""
    };

    obj_gamma_iframe_sub_main.contentWindow.g_obj_hardware_gamma = JSON.parse(JSON.stringify(obj_hardware_gamma));
}


/* -------------------------------------------------------------------接口函数----------------------------------------------------------------- */


